const translations = {
    en: {
        // Header
        language: "Language:",
        "header.title": "CARIBEquity Investor Readiness Assessment",
        "header.description": "This assessment is designed to help you reflect on your readiness as an investor in the Caribbean early-stage ecosystem. It will take around 10–12 minutes. Your answers are confidential and anonymized. The goal is to provide you with insights, and to give you a personalized learning path during the CARIBEquity program. At the end of the program, you will be invited to take the same assessment again to measure your progress.",
        
        // Hero Section
        pageTitle: "CARIBEquity Investor Readiness Assessment",
        heroDescription: "This assessment is designed to help you reflect on your readiness as an investor in the Caribbean early-stage ecosystem. It will take around 10–12 minutes. Your answers are confidential and anonymized. The goal is to provide you with insights, and to give you a personalized learning path during the CARIBEquity program. At the end of the program, you will be invited to take the same assessment again to measure your progress.",
        
        // Section Titles
        section1Title: "Section 1 – Profile & Context",
        section2Title: "Section 2 – Knowledge & Risks",
        section3Title: "Section 3 – Deal Sourcing & Selection",
        section4Title: "Section 4 – Due Diligence & Valuation",
        section5Title: "Section 5 – Portfolio Management",
        section6Title: "Section 6 – Impact & ESG",
        section7Title: "Section 7 – Track Record",
        section8Title: "Section 8 – Demographics",
        contactTitle: "Contact Information",
        
        // Section Descriptions
        section1Desc: "Max Points: 0 (Baseline information only)",
        section2Desc: "Max Points: 30",
        section3Desc: "Max Points: 15",
        section4Desc: "Max Points: 20",
        section5Desc: "Max Points: 15",
        section6Desc: "Max Points: 15",
        section7Desc: "Max Points: 20",
        section8Desc: "Max Points: 0 (Baseline information only)",
        contactDesc: "Required for tool access and follow-up",
        
        // Question Types
        singleMandatory: "Single choice, Mandatory",
        multipleMandatory: "Multiple choice, Mandatory",
        multipleSelect: "Multiple choice, Mandatory (Select all that apply)",
        likertMandatory: "Likert 1–5 for each (1 = Not at all comfortable, 5 = Very comfortable), Mandatory",
        likertImportance: "Likert 1–5 for each (1 = Not important, 5 = Very important), Mandatory",
        likertFamiliarity: "Likert 1–5 for each (1 = Not at all, 5 = Very familiar), Mandatory",
        likertFrequency: "Likert 1–5 for each (1 = Never, 5 = Very often), Mandatory",
        likertImportanceSingle: "Likert 1–5, Mandatory (1 = Not important, 5 = Very important)",
        scaleFamiliarity: "Scale 0–10, Mandatory",
        optional: "Optional",
        
        // Section 1 Questions
        q1a: "Q1a. Which type of investor best describes you?",
        q1aHNWI: "High Net Worth Individual (HNWIs)",
        q1aEntrepreneur: "Entrepreneur / ESO",
        q1aCorporate: "Corporate",
        q1aOther: "Other (please specify)",
        
        q1b: "Q1b. In which industry or sector are you mainly active?",
        q1bAgriculture: "Agriculture / Agri-business",
        q1bEnergy: "Energy & Clean Tech",
        q1bFinance: "Finance / Fintech",
        q1bTourism: "Tourism / Hospitality",
        q1bHealth: "Health / Life Sciences",
        q1bICT: "ICT / Digital Economy",
        q1bRetail: "Retail / Commerce / Distribution",
        q1bManufacturing: "Manufacturing / Logistics",
        q1bOther: "Other (please specify)",
        
        q1c: "Q1c. What is your primary role or function in your organization?",
        q1cCEO: "C-level executive (CEO, CFO, etc.)",
        q1cDirector: "Senior management / Director",
        q1cInvestor: "Professional investor (fund, family office, angel group)",
        q1cFounder: "Entrepreneur / Founder",
        q1cOther: "Other (please specify)",
        
        q2: "Q2. Where are you primarily based today?",
        q2Caribbean: "Based in the Caribbean",
        q2Diaspora: "Based outside the Caribbean – Diaspora (North America or Europe)",
        q2OtherRegion: "Based outside the Caribbean – Other region",
        q2Other: "Other (please specify)",
        
        // Section 2 Questions
        q6: "Q6. Which risks do you most associate with early-stage investing in the Caribbean?",
        q6TotalLoss: "Total loss of capital invested",
        q6Illiquidity: "Illiquidity (no exit for many years)",
        q6Dilution: "Dilution in later rounds",
        q6Diversification: "Low diversification (concentrated portfolio)",
        q6DontKnow: "I don't know",
        q6Other: "Other (please specify)",
        
        q7: "Q7. Which statement is correct?",
        q7SoldEasily: "Early-stage investments can be sold easily at any time",
        q7Illiquid: "Early-stage investments are illiquid and may last 5–10 years before exit",
        q7Guarantee: "Early-stage investments guarantee a minimum return",
        q7DontKnow: "I don't know",
        
        q8: "Q8. Which investment mechanisms are you familiar with? (select all that apply)",
        q8SPV: "SPV (Special Purpose Vehicle)",
        q8SAFE: "SAFE (Simple Agreement for Future Equity)",
        q8SideLetters: "Side letters (special clauses for certain investors)",
        q8Syndication: "Syndication / co-investment",
        q8None: "None of the above",
        
        q11: "Q11. How comfortable are you with the following challenges of small fragmented markets?",
        q11aLabel: "Multiple jurisdictions and regulatory complexity",
        q11bLabel: "Foreign exchange (FX) risk (currency volatility between USD, local currencies, EUR, etc.)",
        q11cLabel: "Logistics and infrastructure challenges",
        q11dLabel: "Small deal sizes (harder to scale investments)",
        
        // Section 3 Questions
        q9: "Q9. Suppose you invest USD 50,000 in a Caribbean start-up. If the company fails, what level of loss could you realistically absorb without harming your financial security?",
        q925Percent: "25% (USD 12,500)",
        q950Percent: "50% (USD 25,000)",
        q975Percent: "75% (USD 37,500)",
        q9100Percent: "100% (USD 50,000)",
        q9DontKnow: "I don't know",
        
        // Section 4 Questions
        q10: "Q10. How familiar are you with the following Caribbean sectors?",
        q10aLabel: "Agriculture & agri-tech",
        q10bLabel: "Blue economy (ocean industries)",
        q10cLabel: "Sustainable tourism",
        q10dLabel: "Fintech / digital finance",
        q10eLabel: "Energy & Clean Tech",
        q10fLabel: "Food & Food Security",
        q10gLabel: "Health / Life Sciences",
        q10hLabel: "Retail / Commerce / Distribution",
        
        q12: "Q12. How important is co-investment or syndication to you as a strategy to manage risks?",
        
        // Section 5 Questions
        q13: "Q13. When you evaluate an investment opportunity, how important are the following factors?",
        q13aLabel: "Local social impact (jobs, inclusion)",
        q13bLabel: "Gender and diversity lens",
        q13cLabel: "Alignment with UN SDGs / IRIS+ metrics",
        q13dLabel: "Climate risk and resilience",
        
        q14: "Q14. For each of the following tools, indicate your current level of familiarity:",
        q14aLabel: "SDG / IRIS+ mapping",
        q14bLabel: "Gender-lens investing checklist",
        q14cLabel: "Climate quick screen",
        q14NeverHeard: "Never heard of it",
        q14Heard: "Heard of it, but never used",
        q14UsedOnce: "Used once or twice, not comfortable",
        q14Confident: "Confident user, can apply independently",
        
        // Section 6 Questions
        q15: "Q15. Have you ever used a due diligence checklist adapted to early-stage start-ups?",
        q15Regularly: "Yes, regularly",
        q15Sometimes: "Yes, sometimes",
        q15Never: "No, never",
        
        q16: "Q16. How do you usually monitor your investments after closing?",
        q16NoFollowUp: "No formal follow-up",
        q16Annual: "Annual or semi-annual reporting",
        q16Quarterly: "Quarterly reporting + occasional interactions",
        q16ActiveRole: "Active role (board-lite, structured involvement)",
        
        q17: "Q17. In your investment decisions, how often do you experience the following?",
        q17aLabel: "Fear of missing out (FOMO) drives a decision",
        q17bLabel: "Over-concentration / lack of diversification",
        q17cLabel: "Excessive caution delaying decisions",
        q17dLabel: "Clear discipline (ticket size, criteria, sectors)",
        
        // Section 7 Questions
        q3: "Q3. What is your typical average ticket size per deal?",
        q3NotInvested: "I have not invested yet",
        q3Below10k: "Below USD 10,000",
        q310to25k: "USD 10,000 – 25,000",
        q325to100k: "USD 25,000 – 100,000",
        q3Above100k: "Above USD 100,000",
        
        q4: "Q4. What is your expected investment horizon?",
        q4Less3: "Less than 3 years",
        q43to5: "3–5 years",
        q4More5: "More than 5 years",
        q4DontKnow: "I don't know",
        
        q5: "Q5. What role would you like to play after making an investment?",
        q5NoRole: "No active role (purely financial)",
        q5LightFollowUp: "Light follow-up (reports, quarterly updates)",
        q5Mentorship: "Mentorship or operational support",
        q5BoardLite: "Board-lite or governance involvement",
        q5DontKnow: "I don't know",
        
        q18: "Q18. How many deals have you invested in during the last 2 years?",
        q18None: "None",
        q181to2: "1–2",
        q183to5: "3–5",
        q18More5: "More than 5",
        
        q19: "Q19. In which stages have you invested in the last 2 years? (Select all that apply)",
        q19PreSeed: "Pre-seed",
        q19Seed: "Seed",
        q19SeriesA: "Series A",
        q19SeriesB: "Series B or later",
        q19None: "None / Not applicable",
        
        q20: "Q20. When was your last investment in an early-stage company?",
        q20Less6: "Less than 6 months ago",
        q206to12: "6–12 months ago",
        q20More12: "More than 12 months ago",
        q20Never: "Never invested",
        
        // Section 8 Questions
        q21: "Q21. What is your age group?",
        q21Under30: "Under 30",
        q2130to39: "30–39",
        q2140to49: "40–49",
        q2150to59: "50–59",
        q2160Plus: "60+",
        q21Prefer: "Prefer not to say",
        
        q22: "Q22. What is your gender?",
        q22Female: "Female",
        q22Male: "Male",
        q22NonBinary: "Non-binary / Prefer to self-describe",
        q22Prefer: "Prefer not to say",
        
        // Contact Fields
        firstName: "First Name",
        lastName: "Last Name",
        email: "Email Address",
        companyName: "Company/Organization Name",
        linkedinProfile: "LinkedIn Profile (Optional)",
        consent: "I consent to CARIBEquity using my assessment data to provide personalized support, program updates, and follow-up communications. My data will be kept confidential and anonymized for program evaluation purposes.",
        
        // Placeholders
        firstNamePlaceholder: "Enter your first name",
        lastNamePlaceholder: "Enter your last name",
        emailPlaceholder: "your.email@example.com",
        companyNamePlaceholder: "Enter your company or organization name",
        linkedinPlaceholder: "https://www.linkedin.com/in/yourprofile",
        
        // Submit Button
        submitButton: "Complete Assessment & Access Tools",
        submitNote: "By submitting this assessment, you'll get immediate access to all 10 tools",
        
        // Footer
        supportedBy: "Supported By"
    },
    
    fr: {
        // Header
        language: "Langue :",
        "header.title": "Évaluation de la Préparation des Investisseurs CARIBEquity",
        "header.description": "Cette évaluation est conçue pour vous aider à réfléchir à votre préparation en tant qu'investisseur dans l'écosystème des entreprises en démarrage des Caraïbes. Elle prendra environ 10 à 12 minutes. Vos réponses sont confidentielles et anonymisées. L'objectif est de vous fournir des informations et de vous proposer un parcours d'apprentissage personnalisé pendant le programme CARIBEquity. À la fin du programme, vous serez invité à refaire la même évaluation pour mesurer vos progrès.",
        
        // Hero Section
        pageTitle: "Évaluation de la Préparation des Investisseurs CARIBEquity",
        heroDescription: "Cette évaluation est conçue pour vous aider à réfléchir à votre préparation en tant qu'investisseur dans l'écosystème des entreprises en démarrage des Caraïbes. Elle prendra environ 10 à 12 minutes. Vos réponses sont confidentielles et anonymisées. L'objectif est de vous fournir des informations et de vous proposer un parcours d'apprentissage personnalisé pendant le programme CARIBEquity. À la fin du programme, vous serez invité à refaire la même évaluation pour mesurer vos progrès.",
        
        // Section Titles
        section1Title: "Section 1 – Profil et Contexte",
        section2Title: "Section 2 – Connaissances et Risques",
        section3Title: "Section 3 – Sourcing et Sélection des Deals",
        section4Title: "Section 4 – Due Diligence et Valorisation",
        section5Title: "Section 5 – Gestion de Portefeuille",
        section6Title: "Section 6 – Impact et ESG",
        section7Title: "Section 7 – Historique",
        section8Title: "Section 8 – Données Démographiques",
        contactTitle: "Informations de Contact",
        
        // Section Descriptions
        section1Desc: "Points Max : 0 (Informations de base uniquement)",
        section2Desc: "Points Max : 30",
        section3Desc: "Points Max : 15",
        section4Desc: "Points Max : 20",
        section5Desc: "Points Max : 15",
        section6Desc: "Points Max : 15",
        section7Desc: "Points Max : 20",
        section8Desc: "Points Max : 0 (Informations de base uniquement)",
        contactDesc: "Requis pour l'accès aux outils et le suivi",
        
        // Question Types
        singleMandatory: "Choix unique, Obligatoire",
        multipleMandatory: "Choix multiple, Obligatoire",
        multipleSelect: "Choix multiple, Obligatoire (Sélectionnez toutes les réponses qui s'appliquent)",
        likertMandatory: "Échelle 1–5 pour chaque (1 = Pas du tout à l'aise, 5 = Très à l'aise), Obligatoire",
        likertImportance: "Échelle 1–5 pour chaque (1 = Pas important, 5 = Très important), Obligatoire",
        likertFamiliarity: "Échelle 1–5 pour chaque (1 = Pas du tout, 5 = Très familier), Obligatoire",
        likertFrequency: "Échelle 1–5 pour chaque (1 = Jamais, 5 = Très souvent), Obligatoire",
        likertImportanceSingle: "Échelle 1–5, Obligatoire (1 = Pas important, 5 = Très important)",
        scaleFamiliarity: "Échelle 0–10, Obligatoire",
        optional: "Optionnel",
        
        // Section 1 Questions
        q1a: "Q1a. Quel type d'investisseur vous décrit le mieux ?",
        q1aHNWI: "Particulier fortuné (HNWI)",
        q1aEntrepreneur: "Entrepreneur / ESO",
        q1aCorporate: "Entreprise",
        q1aOther: "Autre (veuillez préciser)",
        
        q1b: "Q1b. Dans quel secteur d'activité êtes-vous principalement actif ?",
        q1bAgriculture: "Agriculture / Agro-industrie",
        q1bEnergy: "Énergie et Technologies Propres",
        q1bFinance: "Finance / Fintech",
        q1bTourism: "Tourisme / Hôtellerie",
        q1bHealth: "Santé / Sciences de la Vie",
        q1bICT: "TIC / Économie Numérique",
        q1bRetail: "Commerce de Détail / Distribution",
        q1bManufacturing: "Fabrication / Logistique",
        q1bOther: "Autre (veuillez préciser)",
        
        q1c: "Q1c. Quel est votre rôle ou fonction principal dans votre organisation ?",
        q1cCEO: "Cadre de direction (PDG, DG, etc.)",
        q1cDirector: "Direction générale / Directeur",
        q1cInvestor: "Investisseur professionnel (fonds, family office, groupe d'anges)",
        q1cFounder: "Entrepreneur / Fondateur",
        q1cOther: "Autre (veuillez préciser)",
        
        q2: "Q2. Où êtes-vous principalement basé aujourd'hui ?",
        q2Caribbean: "Basé dans les Caraïbes",
        q2Diaspora: "Basé hors des Caraïbes – Diaspora (Amérique du Nord ou Europe)",
        q2OtherRegion: "Basé hors des Caraïbes – Autre région",
        q2Other: "Autre (veuillez préciser)",
        
        // Section 2 Questions
        q6: "Q6. Quels risques associez-vous le plus à l'investissement en phase de démarrage dans les Caraïbes ?",
        q6TotalLoss: "Perte totale du capital investi",
        q6Illiquidity: "Illiquidité (pas de sortie pendant de nombreuses années)",
        q6Dilution: "Dilution lors des tours suivants",
        q6Diversification: "Faible diversification (portefeuille concentré)",
        q6DontKnow: "Je ne sais pas",
        q6Other: "Autre (veuillez préciser)",
        
        q7: "Q7. Quelle affirmation est correcte ?",
        q7SoldEasily: "Les investissements en phase de démarrage peuvent être vendus facilement à tout moment",
        q7Illiquid: "Les investissements en phase de démarrage sont illiquides et peuvent durer 5 à 10 ans avant la sortie",
        q7Guarantee: "Les investissements en phase de démarrage garantissent un rendement minimum",
        q7DontKnow: "Je ne sais pas",
        
        q8: "Q8. Quels mécanismes d'investissement connaissez-vous ? (sélectionnez toutes les réponses qui s'appliquent)",
        q8SPV: "SPV (Véhicule à Usage Spécial)",
        q8SAFE: "SAFE (Accord Simple pour Actions Futures)",
        q8SideLetters: "Lettres annexes (clauses spéciales pour certains investisseurs)",
        q8Syndication: "Syndication / co-investissement",
        q8None: "Aucune des réponses ci-dessus",
        
        q11: "Q11. Dans quelle mesure êtes-vous à l'aise avec les défis suivants des petits marchés fragmentés ?",
        q11aLabel: "Juridictions multiples et complexité réglementaire",
        q11bLabel: "Risque de change (volatilité des devises entre USD, devises locales, EUR, etc.)",
        q11cLabel: "Défis logistiques et d'infrastructure",
        q11dLabel: "Petites tailles de transactions (plus difficile à mettre à l'échelle)",
        
        // Section 3 Questions
        q9: "Q9. Supposons que vous investissiez 50 000 USD dans une start-up des Caraïbes. Si l'entreprise échoue, quel niveau de perte pourriez-vous absorber de manière réaliste sans nuire à votre sécurité financière ?",
        q925Percent: "25 % (12 500 USD)",
        q950Percent: "50 % (25 000 USD)",
        q975Percent: "75 % (37 500 USD)",
        q9100Percent: "100 % (50 000 USD)",
        q9DontKnow: "Je ne sais pas",
        
        // Section 4 Questions
        q10: "Q10. Dans quelle mesure connaissez-vous les secteurs suivants des Caraïbes ?",
        q10aLabel: "Agriculture et agro-technologie",
        q10bLabel: "Économie bleue (industries océaniques)",
        q10cLabel: "Tourisme durable",
        q10dLabel: "Fintech / finance numérique",
        q10eLabel: "Énergie et Technologies Propres",
        q10fLabel: "Alimentation et Sécurité Alimentaire",
        q10gLabel: "Santé / Sciences de la Vie",
        q10hLabel: "Commerce de Détail / Distribution",
        
        q12: "Q12. Quelle est l'importance du co-investissement ou de la syndication pour vous en tant que stratégie de gestion des risques ?",
        
        // Section 5 Questions
        q13: "Q13. Lorsque vous évaluez une opportunité d'investissement, quelle est l'importance des facteurs suivants ?",
        q13aLabel: "Impact social local (emplois, inclusion)",
        q13bLabel: "Perspective de genre et de diversité",
        q13cLabel: "Alignement avec les ODD / métriques IRIS+",
        q13dLabel: "Risque climatique et résilience",
        
        q14: "Q14. Pour chacun des outils suivants, indiquez votre niveau de familiarité actuel :",
        q14aLabel: "Cartographie ODD / IRIS+",
        q14bLabel: "Liste de contrôle d'investissement sensible au genre",
        q14cLabel: "Évaluation rapide du climat",
        q14NeverHeard: "Jamais entendu parler",
        q14Heard: "Entendu parler, mais jamais utilisé",
        q14UsedOnce: "Utilisé une ou deux fois, pas à l'aise",
        q14Confident: "Utilisateur confiant, peut appliquer de manière indépendante",
        
        // Section 6 Questions
        q15: "Q15. Avez-vous déjà utilisé une liste de contrôle de due diligence adaptée aux start-ups en phase de démarrage ?",
        q15Regularly: "Oui, régulièrement",
        q15Sometimes: "Oui, parfois",
        q15Never: "Non, jamais",
        
        q16: "Q16. Comment surveillez-vous généralement vos investissements après la clôture ?",
        q16NoFollowUp: "Aucun suivi formel",
        q16Annual: "Rapport annuel ou semestriel",
        q16Quarterly: "Rapport trimestriel + interactions occasionnelles",
        q16ActiveRole: "Rôle actif (board-lite, implication structurée)",
        
        q17: "Q17. Dans vos décisions d'investissement, à quelle fréquence rencontrez-vous les situations suivantes ?",
        q17aLabel: "La peur de manquer quelque chose (FOMO) motive une décision",
        q17bLabel: "Sur-concentration / manque de diversification",
        q17cLabel: "Prudence excessive retardant les décisions",
        q17dLabel: "Discipline claire (taille du ticket, critères, secteurs)",
        
        // Section 7 Questions
        q3: "Q3. Quelle est votre taille de ticket moyenne typique par transaction ?",
        q3NotInvested: "Je n'ai pas encore investi",
        q3Below10k: "Moins de 10 000 USD",
        q310to25k: "10 000 – 25 000 USD",
        q325to100k: "25 000 – 100 000 USD",
        q3Above100k: "Plus de 100 000 USD",
        
        q4: "Q4. Quel est votre horizon d'investissement attendu ?",
        q4Less3: "Moins de 3 ans",
        q43to5: "3–5 ans",
        q4More5: "Plus de 5 ans",
        q4DontKnow: "Je ne sais pas",
        
        q5: "Q5. Quel rôle aimeriez-vous jouer après avoir effectué un investissement ?",
        q5NoRole: "Aucun rôle actif (purement financier)",
        q5LightFollowUp: "Suivi léger (rapports, mises à jour trimestrielles)",
        q5Mentorship: "Mentorat ou soutien opérationnel",
        q5BoardLite: "Board-lite ou implication en gouvernance",
        q5DontKnow: "Je ne sais pas",
        
        q18: "Q18. Combien de transactions avez-vous effectuées au cours des 2 dernières années ?",
        q18None: "Aucune",
        q181to2: "1–2",
        q183to5: "3–5",
        q18More5: "Plus de 5",
        
        q19: "Q19. Dans quelles étapes avez-vous investi au cours des 2 dernières années ? (Sélectionnez toutes les réponses qui s'appliquent)",
        q19PreSeed: "Pré-amorçage",
        q19Seed: "Amorçage",
        q19SeriesA: "Série A",
        q19SeriesB: "Série B ou ultérieure",
        q19None: "Aucune / Non applicable",
        
        q20: "Q20. Quand avez-vous effectué votre dernier investissement dans une entreprise en phase de démarrage ?",
        q20Less6: "Il y a moins de 6 mois",
        q206to12: "Il y a 6 à 12 mois",
        q20More12: "Il y a plus de 12 mois",
        q20Never: "Jamais investi",
        
        // Section 8 Questions
        q21: "Q21. Quel est votre groupe d'âge ?",
        q21Under30: "Moins de 30 ans",
        q2130to39: "30–39 ans",
        q2140to49: "40–49 ans",
        q2150to59: "50–59 ans",
        q2160Plus: "60 ans et plus",
        q21Prefer: "Préfère ne pas dire",
        
        q22: "Q22. Quel est votre genre ?",
        q22Female: "Femme",
        q22Male: "Homme",
        q22NonBinary: "Non-binaire / Préfère s'auto-décrire",
        q22Prefer: "Préfère ne pas dire",
        
        // Contact Fields
        firstName: "Prénom",
        lastName: "Nom",
        email: "Adresse E-mail",
        companyName: "Nom de l'Entreprise/Organisation",
        linkedinProfile: "Profil LinkedIn (Optionnel)",
        consent: "Je consens à ce que CARIBEquity utilise mes données d'évaluation pour fournir un soutien personnalisé, des mises à jour du programme et des communications de suivi. Mes données seront gardées confidentielles et anonymisées à des fins d'évaluation du programme.",
        
        // Placeholders
        firstNamePlaceholder: "Entrez votre prénom",
        lastNamePlaceholder: "Entrez votre nom",
        emailPlaceholder: "votre.email@exemple.com",
        companyNamePlaceholder: "Entrez le nom de votre entreprise ou organisation",
        linkedinPlaceholder: "https://www.linkedin.com/in/votreprofil",
        
        // Submit Button
        submitButton: "Terminer l'Évaluation et Accéder aux Outils",
        submitNote: "En soumettant cette évaluation, vous aurez un accès immédiat aux 10 outils",
        
        // Footer
        supportedBy: "Soutenu Par"
    },
    
    es: {
        // Header
        language: "Idioma:",
        "header.title": "Evaluación de Preparación de Inversores CARIBEquity",
        "header.description": "Esta evaluación está diseñada para ayudarle a reflexionar sobre su preparación como inversor en el ecosistema de empresas emergentes del Caribe. Tomará alrededor de 10 a 12 minutos. Sus respuestas son confidenciales y anónimas. El objetivo es proporcionarle información y ofrecerle un camino de aprendizaje personalizado durante el programa CARIBEquity. Al final del programa, se le invitará a realizar la misma evaluación nuevamente para medir su progreso.",
        
        // Hero Section
        pageTitle: "Evaluación de Preparación de Inversores CARIBEquity",
        heroDescription: "Esta evaluación está diseñada para ayudarle a reflexionar sobre su preparación como inversor en el ecosistema de empresas emergentes del Caribe. Tomará alrededor de 10 a 12 minutos. Sus respuestas son confidenciales y anónimas. El objetivo es proporcionarle información y ofrecerle un camino de aprendizaje personalizado durante el programa CARIBEquity. Al final del programa, se le invitará a realizar la misma evaluación nuevamente para medir su progreso.",
        
        // Section Titles
        section1Title: "Sección 1 – Perfil y Contexto",
        section2Title: "Sección 2 – Conocimientos y Riesgos",
        section3Title: "Sección 3 – Búsqueda y Selección de Oportunidades",
        section4Title: "Sección 4 – Debida Diligencia y Valoración",
        section5Title: "Sección 5 – Gestión de Cartera",
        section6Title: "Sección 6 – Impacto y ESG",
        section7Title: "Sección 7 – Historial",
        section8Title: "Sección 8 – Datos Demográficos",
        contactTitle: "Información de Contacto",
        
        // Section Descriptions
        section1Desc: "Puntos Máx: 0 (Solo información básica)",
        section2Desc: "Puntos Máx: 30",
        section3Desc: "Puntos Máx: 15",
        section4Desc: "Puntos Máx: 20",
        section5Desc: "Puntos Máx: 15",
        section6Desc: "Puntos Máx: 15",
        section7Desc: "Puntos Máx: 20",
        section8Desc: "Puntos Máx: 0 (Solo información básica)",
        contactDesc: "Requerido para acceso a herramientas y seguimiento",
        
        // Question Types
        singleMandatory: "Opción única, Obligatorio",
        multipleMandatory: "Opción múltiple, Obligatorio",
        multipleSelect: "Opción múltiple, Obligatorio (Seleccione todas las que correspondan)",
        likertMandatory: "Escala 1–5 para cada (1 = Nada cómodo, 5 = Muy cómodo), Obligatorio",
        likertImportance: "Escala 1–5 para cada (1 = No importante, 5 = Muy importante), Obligatorio",
        likertFamiliarity: "Escala 1–5 para cada (1 = Nada, 5 = Muy familiarizado), Obligatorio",
        likertFrequency: "Escala 1–5 para cada (1 = Nunca, 5 = Muy a menudo), Obligatorio",
        likertImportanceSingle: "Escala 1–5, Obligatorio (1 = No importante, 5 = Muy importante)",
        scaleFamiliarity: "Escala 0–10, Obligatorio",
        optional: "Opcional",
        
        // Section 1 Questions
        q1a: "Q1a. ¿Qué tipo de inversor le describe mejor?",
        q1aHNWI: "Individuo de Alto Patrimonio (HNWI)",
        q1aEntrepreneur: "Emprendedor / ESO",
        q1aCorporate: "Corporativo",
        q1aOther: "Otro (por favor especifique)",
        
        q1b: "Q1b. ¿En qué industria o sector está principalmente activo?",
        q1bAgriculture: "Agricultura / Agronegocios",
        q1bEnergy: "Energía y Tecnología Limpia",
        q1bFinance: "Finanzas / Fintech",
        q1bTourism: "Turismo / Hospitalidad",
        q1bHealth: "Salud / Ciencias de la Vida",
        q1bICT: "TIC / Economía Digital",
        q1bRetail: "Comercio Minorista / Distribución",
        q1bManufacturing: "Manufactura / Logística",
        q1bOther: "Otro (por favor especifique)",
        
        q1c: "Q1c. ¿Cuál es su rol o función principal en su organización?",
        q1cCEO: "Ejecutivo de nivel C (CEO, CFO, etc.)",
        q1cDirector: "Alta dirección / Director",
        q1cInvestor: "Inversor profesional (fondo, family office, grupo de ángeles)",
        q1cFounder: "Emprendedor / Fundador",
        q1cOther: "Otro (por favor especifique)",
        
        q2: "Q2. ¿Dónde está basado principalmente hoy?",
        q2Caribbean: "Basado en el Caribe",
        q2Diaspora: "Basado fuera del Caribe – Diáspora (América del Norte o Europa)",
        q2OtherRegion: "Basado fuera del Caribe – Otra región",
        q2Other: "Otro (por favor especifique)",
        
        // Section 2 Questions
        q6: "Q6. ¿Qué riesgos asocia más con la inversión en etapa temprana en el Caribe?",
        q6TotalLoss: "Pérdida total del capital invertido",
        q6Illiquidity: "Iliquidez (sin salida durante muchos años)",
        q6Dilution: "Dilución en rondas posteriores",
        q6Diversification: "Baja diversificación (cartera concentrada)",
        q6DontKnow: "No lo sé",
        q6Other: "Otro (por favor especifique)",
        
        q7: "Q7. ¿Qué afirmación es correcta?",
        q7SoldEasily: "Las inversiones en etapa temprana se pueden vender fácilmente en cualquier momento",
        q7Illiquid: "Las inversiones en etapa temprana son ilíquidas y pueden durar de 5 a 10 años antes de la salida",
        q7Guarantee: "Las inversiones en etapa temprana garantizan un rendimiento mínimo",
        q7DontKnow: "No lo sé",
        
        q8: "Q8. ¿Con qué mecanismos de inversión está familiarizado? (seleccione todos los que correspondan)",
        q8SPV: "SPV (Vehículo de Propósito Especial)",
        q8SAFE: "SAFE (Acuerdo Simple para Acciones Futuras)",
        q8SideLetters: "Cartas laterales (cláusulas especiales para ciertos inversores)",
        q8Syndication: "Sindicación / co-inversión",
        q8None: "Ninguna de las anteriores",
        
        q11: "Q11. ¿Qué tan cómodo se siente con los siguientes desafíos de los mercados pequeños y fragmentados?",
        q11aLabel: "Múltiples jurisdicciones y complejidad regulatoria",
        q11bLabel: "Riesgo cambiario (volatilidad de divisas entre USD, monedas locales, EUR, etc.)",
        q11cLabel: "Desafíos logísticos y de infraestructura",
        q11dLabel: "Tamaños de transacción pequeños (más difícil de escalar)",
        
        // Section 3 Questions
        q9: "Q9. Suponga que invierte 50,000 USD en una startup del Caribe. Si la empresa fracasa, ¿qué nivel de pérdida podría absorber de manera realista sin dañar su seguridad financiera?",
        q925Percent: "25% (12,500 USD)",
        q950Percent: "50% (25,000 USD)",
        q975Percent: "75% (37,500 USD)",
        q9100Percent: "100% (50,000 USD)",
        q9DontKnow: "No lo sé",
        
        // Section 4 Questions
        q10: "Q10. ¿Qué tan familiarizado está con los siguientes sectores del Caribe?",
        q10aLabel: "Agricultura y agrotecnología",
        q10bLabel: "Economía azul (industrias oceánicas)",
        q10cLabel: "Turismo sostenible",
        q10dLabel: "Fintech / finanzas digitales",
        q10eLabel: "Energía y Tecnología Limpia",
        q10fLabel: "Alimentación y Seguridad Alimentaria",
        q10gLabel: "Salud / Ciencias de la Vida",
        q10hLabel: "Comercio Minorista / Distribución",
        
        q12: "Q12. ¿Qué tan importante es la co-inversión o sindicación para usted como estrategia para gestionar riesgos?",
        
        // Section 5 Questions
        q13: "Q13. Cuando evalúa una oportunidad de inversión, ¿qué tan importantes son los siguientes factores?",
        q13aLabel: "Impacto social local (empleos, inclusión)",
        q13bLabel: "Perspectiva de género y diversidad",
        q13cLabel: "Alineación con ODS / métricas IRIS+",
        q13dLabel: "Riesgo climático y resiliencia",
        
        q14: "Q14. Para cada una de las siguientes herramientas, indique su nivel actual de familiaridad:",
        q14aLabel: "Mapeo de ODS / IRIS+",
        q14bLabel: "Lista de verificación de inversión con perspectiva de género",
        q14cLabel: "Evaluación rápida del clima",
        q14NeverHeard: "Nunca he oído hablar de ello",
        q14Heard: "He oído hablar de ello, pero nunca lo he usado",
        q14UsedOnce: "Lo he usado una o dos veces, no me siento cómodo",
        q14Confident: "Usuario confiado, puedo aplicarlo de forma independiente",
        
        // Section 6 Questions
        q15: "Q15. ¿Alguna vez ha utilizado una lista de verificación de debida diligencia adaptada a startups en etapa temprana?",
        q15Regularly: "Sí, regularmente",
        q15Sometimes: "Sí, a veces",
        q15Never: "No, nunca",
        
        q16: "Q16. ¿Cómo suele monitorear sus inversiones después del cierre?",
        q16NoFollowUp: "Sin seguimiento formal",
        q16Annual: "Informes anuales o semestrales",
        q16Quarterly: "Informes trimestrales + interacciones ocasionales",
        q16ActiveRole: "Rol activo (board-lite, participación estructurada)",
        
        q17: "Q17. En sus decisiones de inversión, ¿con qué frecuencia experimenta lo siguiente?",
        q17aLabel: "El miedo a perderse algo (FOMO) impulsa una decisión",
        q17bLabel: "Sobre-concentración / falta de diversificación",
        q17cLabel: "Cautela excesiva que retrasa las decisiones",
        q17dLabel: "Disciplina clara (tamaño del ticket, criterios, sectores)",
        
        // Section 7 Questions
        q3: "Q3. ¿Cuál es su tamaño de ticket promedio típico por transacción?",
        q3NotInvested: "Aún no he invertido",
        q3Below10k: "Menos de 10,000 USD",
        q310to25k: "10,000 – 25,000 USD",
        q325to100k: "25,000 – 100,000 USD",
        q3Above100k: "Más de 100,000 USD",
        
        q4: "Q4. ¿Cuál es su horizonte de inversión esperado?",
        q4Less3: "Menos de 3 años",
        q43to5: "3–5 años",
        q4More5: "Más de 5 años",
        q4DontKnow: "No lo sé",
        
        q5: "Q5. ¿Qué rol le gustaría desempeñar después de realizar una inversión?",
        q5NoRole: "Sin rol activo (puramente financiero)",
        q5LightFollowUp: "Seguimiento ligero (informes, actualizaciones trimestrales)",
        q5Mentorship: "Mentoría o apoyo operativo",
        q5BoardLite: "Board-lite o participación en gobernanza",
        q5DontKnow: "No lo sé",
        
        q18: "Q18. ¿Cuántas transacciones ha realizado en los últimos 2 años?",
        q18None: "Ninguna",
        q181to2: "1–2",
        q183to5: "3–5",
        q18More5: "Más de 5",
        
        q19: "Q19. ¿En qué etapas ha invertido en los últimos 2 años? (Seleccione todas las que correspondan)",
        q19PreSeed: "Pre-semilla",
        q19Seed: "Semilla",
        q19SeriesA: "Serie A",
        q19SeriesB: "Serie B o posterior",
        q19None: "Ninguna / No aplicable",
        
        q20: "Q20. ¿Cuándo fue su última inversión en una empresa en etapa temprana?",
        q20Less6: "Hace menos de 6 meses",
        q206to12: "Hace 6–12 meses",
        q20More12: "Hace más de 12 meses",
        q20Never: "Nunca he invertido",
        
        // Section 8 Questions
        q21: "Q21. ¿Cuál es su grupo de edad?",
        q21Under30: "Menor de 30",
        q2130to39: "30–39",
        q2140to49: "40–49",
        q2150to59: "50–59",
        q2160Plus: "60+",
        q21Prefer: "Prefiero no decir",
        
        q22: "Q22. ¿Cuál es su género?",
        q22Female: "Femenino",
        q22Male: "Masculino",
        q22NonBinary: "No binario / Prefiero autodescribirme",
        q22Prefer: "Prefiero no decir",
        
        // Contact Fields
        firstName: "Nombre",
        lastName: "Apellido",
        email: "Correo Electrónico",
        companyName: "Nombre de la Empresa/Organización",
        linkedinProfile: "Perfil de LinkedIn (Opcional)",
        consent: "Doy mi consentimiento para que CARIBEquity utilice mis datos de evaluación para proporcionar apoyo personalizado, actualizaciones del programa y comunicaciones de seguimiento. Mis datos se mantendrán confidenciales y se anonimizarán para fines de evaluación del programa.",
        
        // Placeholders
        firstNamePlaceholder: "Ingrese su nombre",
        lastNamePlaceholder: "Ingrese su apellido",
        emailPlaceholder: "su.correo@ejemplo.com",
        companyNamePlaceholder: "Ingrese el nombre de su empresa u organización",
        linkedinPlaceholder: "https://www.linkedin.com/in/superfil",
        
        // Submit Button
        submitButton: "Completar Evaluación y Acceder a las Herramientas",
        submitNote: "Al enviar esta evaluación, obtendrá acceso inmediato a las 10 herramientas",
        
        // Footer
        supportedBy: "Apoyado Por"
    }
};

